import alice.tucson.api.*;
import alice.logictuple.*;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;

/*Thread che si occupa di osservare se qualche utente intende entrare in chat
 *
 *@author Rossella Rubino
 *@version agosto1 2004 
 */

public class ObserverJoin extends Thread {
        
        private TucsonContext context;
        private TupleCentreId chatId,chatIdR;
        private boolean crash=false;
        
        public ObserverJoin(AgentId aid, TupleCentreId id, TupleCentreId idr) throws Exception {
            this.chatId=id;
            this.chatIdR=idr;
            this.context = Tucson.enterContext(new DefaultContextDescription(aid));
        }

        public void run(){
        	try {
            	while (true){          	       
        			LogicTuple temp=LogicTuple.parse("join(_,_)");
        			LogicTuple lt;
	        		
	        		try{
	        			lt=context.in(chatId,temp);	        		  	
	        		}
	        		catch(UnreachableNodeException une){}
	        		try{
	        			lt=context.in(chatIdR,temp);	        		  	
	        		}
	        		catch(UnreachableNodeException une){
	        			lt=context.in(chatId,temp);
	        		}
	        		
	        		String newuser=lt.getArg(0).getArg(0).toString();
	        		String hostUser=toFlatString(lt.getArg(1).getArg(0).toString());
	        		TupleCentreId userTC=new TupleCentreId(newuser.toLowerCase()+" @ '"+hostUser+"'");;
            		        	        
	        		System.out.println(newuser+" intende entrare in chat...controllo nick");
	        					        
	      		  	LogicTuple count=LogicTuple.parse("countUser(_)");
	      		  	LogicTuple numu;
					try{
        				numu=context.in(chatId,count);        		
        			}
        			catch(UnreachableNodeException une){}
        			try{
        				numu=context.in(chatIdR,count);        		
        			}
        			catch(UnreachableNodeException une){
        				numu=context.in(chatId,count); 
        			}
	        		
	        		int n=Integer.parseInt(numu.getArg(0).toString());	        		
	        		
	        		if (n==0)  //non ci sono utenti in chat
	        		{
	        			
	        			context.out(userTC,LogicTuple.parse("accepted("+newuser+",true)"));
	        			System.out.println(newuser+" entra in chat");
	        			try{
	        				context.out(chatId,LogicTuple.parse("user('"+newuser+"','"+hostUser+"')"));
	        			}
	        			catch(UnreachableNodeException une){}
	        			try{
	        				context.out(chatIdR,LogicTuple.parse("user('"+newuser+"','"+hostUser+"')"));
	        			}
	        			catch(UnreachableNodeException une){}
	        			
	        			LogicTuple addu=LogicTuple.parse("countUser("+(n+1)+")");
	        			try{
							context.out(chatId,addu);						
						}
						catch(UnreachableNodeException une){}
						try{
							context.out(chatIdR,addu);						
						}
						catch(UnreachableNodeException une){}
	        		}
	       			else
	       			{			
	        			//controlla che l'utente abbia un nome univoco
	        			Var vt=new Var("Lista");
						LogicTuple tupletemplateEnv=LogicTuple.parse("user(_,_)");	        			
						LogicTuple tlist;
						Term t=null;
						try{
							tlist=context.in(chatId,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt));
							t=vt.toTerm();
						}
						catch(UnreachableNodeException une){}
							
						Var vt2=new Var("Lista");					
						try{
							tlist=context.in(chatIdR,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt2));
							t=vt2.toTerm();
								
						}
						catch(UnreachableNodeException une){}
						
						alice.tuprolog.Var head;									
						Struct lista = (Struct)	t.getTerm();
					
						while (!lista.unify(new Struct())) {
							head = new alice.tuprolog.Var("Head");
							alice.tuprolog.Var tail = new alice.tuprolog.Var("Tail");
							boolean res = lista.unify(new Struct(head,tail));
							lista = (Struct) tail.getTerm();
					
							String tupla=head.toString();						
							LogicTuple ust=LogicTuple.parse(tupla);	
							String usr=ust.getArg(1).getArg(0).toString();											
							
							if (newuser.equals(usr))
							{
								context.out(userTC,LogicTuple.parse("accepted("+newuser+",false)"));
								System.out.println("Il nick "+ newuser+"  gi usato.");
							}
						}
						context.out(userTC,LogicTuple.parse("accepted("+newuser+",true)"));
	        			System.out.println(newuser+" entra in chat");
	        			try{
	        				context.out(chatId,LogicTuple.parse("user('"+newuser+"','"+hostUser+"')"));
	        			}
	        			catch(UnreachableNodeException une){}
	        			try{
	        				context.out(chatIdR,LogicTuple.parse("user('"+newuser+"','"+hostUser+"')"));
	        			}
	        			catch(UnreachableNodeException une){}
	        			
	        			LogicTuple addu=LogicTuple.parse("countUser("+(n+1)+")");
	        			try{
							context.out(chatId,addu);
						}
						catch(UnreachableNodeException une){}
						
						try{
							context.out(chatIdR,addu);
						}
						catch(UnreachableNodeException une){}
						
	       				vt=new Var("Lista");
						tupletemplateEnv=LogicTuple.parse("user(_,_)");	        			
					
						try{
							tlist=context.in(chatId,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt));
							t=vt.toTerm();
						}
						catch(UnreachableNodeException une){}
							
						vt2=new Var("Lista");					
						try{
							tlist=context.in(chatIdR,new LogicTuple("rdall",new TupleArgument(tupletemplateEnv.toTerm()),vt2));
							t=vt2.toTerm();
						}
						catch(UnreachableNodeException une){}
						
										
						lista = (Struct)	t.getTerm();
								
						while (!lista.unify(new Struct())) {
							head = new alice.tuprolog.Var("Head");
							alice.tuprolog.Var tail = new alice.tuprolog.Var("Tail");
							boolean res = lista.unify(new Struct(head,tail));
							lista = (Struct) tail.getTerm();
					
							String tupla=head.toString();										
							LogicTuple ust=LogicTuple.parse(tupla);	
				
							String usr=ust.getArg(1).getArg(0).toString();
							
							userTC=new TupleCentreId(usr.toLowerCase()+" @ '"+hostUser+"'");
            							
							context.out(userTC,lt);
						}									
	     			}	
	     		}
	     	} 
	     	catch(Exception e){
	     		e.printStackTrace();
	     	}      
	     	
		}
		
		/*metodo usato per eliminare gli apici all'inizio e alla fine di una stringa
		 *
		 *@param st stringa su cui lavorare
		 *@return stringa senza apici
		 */
        private String toFlatString(String st){
            if (st.startsWith("'")&&st.endsWith("'")){
                return st.substring(1,st.length()-1);
            } else {
                return st;
            }
        }
}

	